/* copyleft */

#include <sys/time.h>

class CUnixTimer
{
 protected:
	timeval tv1;
	timeval tv2;
	bool started;

 public:	
	CUnixTimer(void)
	{
		started = false;
	};
	void Reset(void)
	{
		gettimeofday(&tv1, NULL);
		tv2 = tv1;
	};
	void Start(void)
	{
		gettimeofday(&tv1, NULL);
		tv2 = tv1;
		started = true;
	};
	float Stop(void)
	{
       if (started)
          gettimeofday(&tv2, NULL);
       
       started = false;
       return Read();
	};
	float Read(void)
	{
		if (started)
			gettimeofday(&tv2, NULL);
		return tv2.tv_sec - tv1.tv_sec + (tv2.tv_usec * 1e-6f - tv1.tv_usec * 1e-6f);
	};
};
