//---------------------------------------------------
//  * File  : exemple.cpp
//  * Author: Lightness1024
//  * Date  : 27/06/2006
//
// Ceci est un programme de test pour la lib polices de mon implmentation
// vous pouvez (devez ?) vous en inspirer pour apprendre comment
// s'en servir.
//
// initialisation, affichage...
//---------------------------------------------------


// cet exemple utilise un fentrage SDL
// ce n'est pas obligatoire pour utiliser la lib polices
#include <SDL/SDL.h>
#include <GL/gl.h>
#include <GL/glu.h>
#include <math.h>
// un timer perso, nul besoin d'inclure ceci dans vos projets.
// si vous voulez tout de mme vous en servir, c'est free for all.
#include "timer.hpp"

// ceci est l'include a mettre
// si votre projet comporte des .h, par souci d'homognit,
// vous pouvez renommer ce fichier en un .h, cela n'a pas d'incidence.
// personnellement j'utilise hpp pour qu'emacs utilise la bonne coloration syntaxique.

#include "polices.hpp"

// il est ncessaire d'avoir compil le module polices.cpp
// pour que l'opration de linkage fonctionne
// ajoutez le a votre makefile, ou bien compilez le
// une fois pour sur votre plateforme, et en root
// copiez le .o dans /usr/lib/libpolices.lib par exemple
// spcifiez ensuite -Lpolices  g++



// ceci est une structure dpendante du programme d'exemple
// ne vous en souciez pas
struct ModeParams
{
      int resx, resy;
      int colorDepth;
      long flags;
      int fov;
      char* winName;
};

// ne pas ce soucier non plus
int InitializeGL(const ModeParams& mode);
bool EscapeRead(void);


//---------------------------------------------------
// point d'entre
//---------------------------------------------------
int main(void)
{
   // code spcifique  l'exemple
   ModeParams parms;

   parms.resx = 800;
   parms.resy = 600;
   parms.colorDepth = 32;
   parms.fov = 80;
   parms.flags = SDL_HWSURFACE | SDL_DOUBLEBUF | SDL_OPENGL;
   parms.winName = "fenetre exemple";

   InitializeGL(parms);

   // l'important pour l'exemple commence ici:

   // on instancie une classe qui va grer une police donne d'une taille donne.
   // il sera possible de changer la taille de rendu du texte
   // avec les fonctions opengl, mais la rsolution pourra tre limite
   // par une taille d'initialisation trop petite
   // le paramtre de taille est spcifi en 'points', comme un logiciel de traitement de texte.

   GPFont iFont("font.ttf", 24);

   // le code suivant vrifie si le chargement s'est correctement droul
   // il n'est pas obligatoire de passer par cette tape
   // si vous devez taper un code quick and dirty.

   if (!iFont.WereLoadedOk())
   {
      printf("problme avec les polices\n");
      return 1;
   }
   // la classe est failsafe, si ca n'a pas march on peut tout de mme appeller ses mthodes,
   // rien ne se produit.


   // quelques variables pour agrmenter la prsentation:
   CUnixTimer timer;
   float lastTime = 0;
   float frameTime;
   float wave, wave2, wave3;
   float dir = 8;
   float mark = 0;

   timer.Start();

   // tant qu'on a pas appuy sur echap
   while (!EscapeRead())
   {
      // pti netotyage de la surface
      glClearColor(0, 0, 0, 0);
      glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
      
      glLoadIdentity();

      // grce aux fonctions opengl
      // on peut rgler la position du texte, la couleur, la taille, la rotation...
      // il peut tre utile d'encadrer les modifications des matrices MODELVIEW
      // par des glPushMatrix et glPopMatrix si ncessaire.

      // gestion du temps:

      frameTime = timer.Read() - lastTime;
      lastTime = timer.Read();
      
      // petit effet
      wave = sin(timer.Read()) * 0.5f + 0.5f;
      wave2 = sin(timer.Read() * 2) * 0.5f + 0.5f;
      wave3 = sin(timer.Read() * 0.2) * 0.5f + 0.5f;

      // couleur variable:
      glColor4f(wave, 0, 1, 1);

      // position:
      glTranslatef(0, 280 + wave2 * 100, 0); // (en pixels)

      // redimensionnement:
      glScalef(wave + 0.7, wave + 0.7, 0);

      // une petite rotation autours de z:
      glRotatef(wave * 20 - 10, 0, 0, 1);

      // et voila la fameuse ligne l'affichage:
      // il est possible d'utiliser directement une syntaxe  la "printf"
      iFont.Print2D("%.1f FPS", 1 / frameTime);

      glLoadIdentity();
      glColor4f(1, 1, 1, 1);
      glTranslatef(0, 100, 0);

      // et finalement, voici une ligne d'exemple dmontrant la possibilit de revenir
      //  la ligne
      iFont.Print2D("ceci est un exemple\nde retour  la ligne.\net encore une :)");

      glLoadIdentity();

      glColor4f(1, 0, 0, 1);

      if ((int)(timer.Read() - mark) % 5 == 4)
      {
         dir = -dir;
         mark = timer.Read();
      }
      glTranslatef(10, 15 + (timer.Read() - mark) * dir - (dir * 2.f), -40);
      glScalef(0.1, 0.1, 0.1);
      glRotatef(30, 0, 1, 0);

      // on peut rgler la hauteur des sauts de lignes !
      float oldfj = iFont.GetFeedJump();
      iFont.SetFeedJump(50);

      // il est aussi possible d'afficher du texte dans l'espace:
      iFont.Print3D("texte en 3D\nsur plusieurs lignes\nil pourrait par exemple\nafficher un gnrique\nquelconque.\nlaissez libre court\n votre imagination ;)");

      iFont.SetFeedJump(oldfj);

      // on peut faire un scroller:

      glLoadIdentity();
      glColor4f(1, 1, 0, 1);
      // 200 pixels par seconde
      glTranslatef(1000 - (int)(timer.Read() * 200) % 2000, 0, 0);

      iFont.Print2D("et voila moi aussi je peux faire des scrollers old school");


      // encore!

      glLoadIdentity();
      glColor4f(0, 1, 1, 0.4);

      glRotatef(-74, 0, 1, 0);
      glTranslatef(wave3 * 50 - 100, -10, -15);
      glScalef(0.1, 0.1, 0.1);

      iFont.Print3D("wooooaaww, magnifique la lib polices !!");

      // et un dernier pour la route, l'hlicoptre:

      glLoadIdentity();
      glColor4f(0.5, 0.5, 1, 1);

      // pour faire tourner autours du centre:
      int midlen = iFont.GetStringPixelWidth("ca tooourne") / 2;

      glTranslatef(380, 550, 0);
      glRotatef(timer.Read() * 90, 0, 1, 0);
      glTranslatef(-midlen, 0, 0);

      iFont.Print2D("ca tooourne");


      SDL_GL_SwapBuffers();
   }

   return 0;
}

// code spcifique  l'exemple
// cela peut servir d'inspiration, mais n'est aucunement li
//  la lib polices:
int InitializeGL(const ModeParams& mode)
{
   SDL_Init(SDL_INIT_TIMER | SDL_INIT_VIDEO);

   if (NULL == SDL_SetVideoMode(mode.resx, mode.resy, mode.colorDepth, mode.flags))
   {
      printf("surface non initialise\n");
      return -1;  // problme.
   }
   SDL_WM_SetCaption(mode.winName, NULL);

   glClearDepth(1.0f);
   glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);  // correction de perspective lors de la projection des texels
   
   glViewport(0, 0, mode.resx, mode.resy);
   glMatrixMode(GL_PROJECTION);
   glLoadIdentity();
   if (mode.fov != 0)
   {
      gluPerspective(mode.fov, mode.resx / (float)mode.resy, 2.0f, 1024.0f);
      glMatrixMode(GL_MODELVIEW);
      glLoadIdentity();
      gluLookAt(0, 0, 50, 0, 0, 0, 0, 1, 0);
   }
   else
   {
      glOrtho(0, mode.resx, 0, mode.resy, -1000, 1000);
   }
   glMatrixMode(GL_MODELVIEW);
   glDisable(GL_CULL_FACE);
   glDisable(GL_LIGHTING);
   
   return 0;
}

bool EscapeRead(void)
{
   SDL_Event e;
   if (SDL_PollEvent(&e))
   {
	  if (e.type == SDL_KEYDOWN)
	  {
         if (e.key.keysym.sym == SDLK_q || e.key.keysym.sym == SDLK_ESCAPE)
		 {
            return true;
		 }
	  }
   }   
   return false;
}
